﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Security.Cryptography;
using System.Text.RegularExpressions;

namespace FCIVShell
{
    public partial class FCIV_Shell : Form
    {
        public FCIV_Shell()
        {
            InitializeComponent();
        }

        private void buttonChangeDirectory_Click(object sender, EventArgs e)
        {
            textBoxStandardOutput.Text = "";
            textBoxStandardError.Text = "";

            System.Windows.Forms.DialogResult drFolderBrowserResult;

            drFolderBrowserResult = folderBrowserDialog1.ShowDialog();
            if (drFolderBrowserResult == System.Windows.Forms.DialogResult.OK)
            {
                textBoxDirectory.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void buttonCreateVerificationFile_Click(object sender, EventArgs e)
        {
            string strRenderFile = "";
            string strRenderFileTemp = "";
            string strVerifyXmlData = "";
            string strRenderFolder = textBoxDirectory.Text.Trim();

            textBoxStandardOutput.Text = "";
            textBoxStandardError.Text = "";
            string strRenderedXmlData = "";

            SoftwareControlsLock();

            if (strRenderFolder == "")
            {
                MessageBox.Show("Select Directory", "Select Directory");
                textBoxDirectory.Focus();
                textBoxDirectory.BackColor = System.Drawing.Color.Yellow;
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }
            else
            {
                textBoxDirectory.BackColor = System.Drawing.Color.White;
            }

            if (!(Directory.Exists(strRenderFolder)))
            {
                MessageBox.Show("Directory doesn't exist", "Directory doesn't exist");
                textBoxDirectory.Focus();
                textBoxDirectory.BackColor = System.Drawing.Color.Yellow;
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }

            // remove trailing slash if not root directory of a mapped drive letter
            if (strRenderFolder.IndexOf(":\\", 0) < 0)   // if not R:\
            {
                if (strRenderFolder.IndexOf('\\', (strRenderFolder.Length - 1)) > -1)
                {
                    strRenderFolder = strRenderFolder.Substring(0, strRenderFolder.Length - 1);
                }
            }

            strRenderFile = strRenderFolder + "\\fciv.xml";
            strRenderFileTemp = strRenderFolder + "\\fciv.tmp";

            if (File.Exists(strRenderFile))
            {
                string strErrorMessage = "";
                strErrorMessage = "Hash file already exists. If you want to re-generate, manually delete ";
                strErrorMessage += strRenderFile;

                MessageBox.Show(strErrorMessage, "Hash file already exists.");
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }

            if (File.Exists(strRenderFileTemp))
            {
                string strErrorMessage = "";
                strErrorMessage = "Hash file already exists. If you want to re-generate, manually delete ";
                strErrorMessage += strRenderFileTemp;

                MessageBox.Show(strErrorMessage, "Hash file already exists.");
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }

            try
            {
                using (System.Diagnostics.Process cmdprc = new System.Diagnostics.Process())
                {
                    string strCommand = "";
                    string strArguments = "PJWQUOTEDFOLDER -bp PJWQUOTEDFOLDER PJWRECURSIVEPJWHASHMETHOD -wp -xml \"PJWFOLDER\\fciv.tmp\"";
                    string strHashMethod = "";
                    string strCreateRecursively = "";
                    string strQuotedFolder = "";

                    string strStandardOutput = "";
                    string strTempString = "";
                    string strStandardError = "";

                    if ((checkBoxUseMD5.Checked == true) && (checkBoxUseSha1.Checked == true))
                    {
                        strHashMethod = "-both";
                    }
                    else if (checkBoxUseMD5.Checked == true)
                    {
                        strHashMethod = "-md5";
                    }
                    else if (checkBoxUseSha1.Checked == true)
                    {
                        strHashMethod = "-sha1";
                    }
                    else
                    {
                        strHashMethod = "-both";
                    }

                    if (checkBoxCreateRecursively.Checked == true)
                    {
                        strCreateRecursively = "-r ";
                    }
                    else
                    {
                        strCreateRecursively = " ";
                    }

                    // work around a problem where "R:\" wouldn't work when sending folder parameters to fciv.exe -- double-quote only if the folder name contains a space
                    if (strRenderFolder.Contains(' '))
                    {
                        strQuotedFolder = "\"";
                        strQuotedFolder += strRenderFolder;
                        strQuotedFolder += "\"";
                    }
                    else
                    {
                        strQuotedFolder += strRenderFolder;
                    }


                    // add trailing slash to R: if missing
                    if (strQuotedFolder.IndexOf("\\", 0) < 0)
                    {
                        strQuotedFolder += "\\";
                    }

                    strCommand = "fciv.exe";

                    strArguments = strArguments.Replace("PJWFOLDER", strRenderFolder);
                    strArguments = strArguments.Replace("PJWHASHMETHOD", strHashMethod);
                    strArguments = strArguments.Replace("PJWRECURSIVE", strCreateRecursively);
                    strArguments = strArguments.Replace("PJWQUOTEDFOLDER", strQuotedFolder);

                    // with R:\ getting replaced in the command-line, you will get R:\\.... -- remove one slash                    
                    strArguments = strArguments.Replace(":\\\\", ":\\");

                    cmdprc.StartInfo.UseShellExecute = false;
                    cmdprc.StartInfo.RedirectStandardError = true;
                    cmdprc.StartInfo.RedirectStandardOutput = true;
                    cmdprc.StartInfo.CreateNoWindow = true;
                    cmdprc.StartInfo.FileName = strCommand;
                    cmdprc.StartInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
                    cmdprc.StartInfo.Arguments = strArguments;
                    cmdprc.Start();

                    
                    strTempString = cmdprc.StandardError.ReadLine();
                    while (strTempString != null)
                    {
                        strStandardError += strTempString;
                        strStandardError += "\r\n";
                        strTempString = cmdprc.StandardError.ReadLine();
                    }

                    strTempString = cmdprc.StandardOutput.ReadLine();
                    while (strTempString != null)
                    {
                        strStandardOutput += strTempString;
                        strStandardOutput += "\r\n";
                        strTempString = cmdprc.StandardOutput.ReadLine();
                    }
                    cmdprc.WaitForExit();

                    textBoxStandardError.Text = strStandardError;
                    textBoxStandardOutput.Text = strStandardOutput;
                }
            }
            catch (Exception ex)
            {
                string strErrorMessage = "Be sure that FCIV.exe is installed in the same directory that this software is.\n\n";
                strErrorMessage += ex.Message;
                MessageBox.Show(strErrorMessage);
                SoftwareControlsUnlock();
                return;
            }



            // remove MD5 and SHA1 hash of fciv.xml (fciv.tmp) from fciv.xml  (it's a bad hash from an early (semi empty version of the file))
            try
            {
                // read fciv.tmp
                FileStream fs = new FileStream(strRenderFileTemp, FileMode.Open, FileAccess.Read, FileShare.Read);
                StreamReader sr = new StreamReader(fs);
                if (sr.Peek() > -1)
                {
                    strRenderedXmlData = sr.ReadToEnd();
                }
                sr.Close();
                fs.Close();

                // remove some <FILE_ENTRY> entries
                strRenderedXmlData = RemoveBetween(strRenderedXmlData, "<FILE_ENTRY><name>$RECYCLE", "</FILE_ENTRY>");
                strRenderedXmlData = RemoveBetween(strRenderedXmlData, "<FILE_ENTRY><name>fciv.tmp", "</FILE_ENTRY>");

                // write new fciv.xml file (with some entries removed)                
                FileStream fs2 = new FileStream(strRenderFile, FileMode.Create, FileAccess.Write, FileShare.Read);

// 20140120 change encoding parameter when re-writing fciv.xml
//                StreamWriter sw2 = new StreamWriter(fs2, System.Text.Encoding.Default);
                StreamWriter sw2 = new StreamWriter(fs2, System.Text.Encoding.UTF8);

                sw2.Write(strRenderedXmlData);
                sw2.Close();
                fs2.Close();

                // Verify new FCIV file
                FileStream fs3 = new FileStream(strRenderFile, FileMode.Open, FileAccess.Read, FileShare.Read);
                StreamReader sr3 = new StreamReader(fs3);
                if (sr3.Peek() > -1)
                {
                    strVerifyXmlData = sr3.ReadToEnd();
                }
                sr3.Close();
                fs3.Close();
                if (strVerifyXmlData == strRenderedXmlData)
                {
                    // no longer need the fciv.tmp file
                    File.Delete(strRenderFileTemp);
                }
                else
                {
                    MessageBox.Show("File corruption occurred when creating fciv.xml file");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            
            SoftwareControlsUnlock();
        }


        public string RemoveBetween(string s, string begin, string end)
        {
            string strBeginTemp = Regex.Escape(begin);
            string strEndTemp = Regex.Escape(end);

            Regex regex = new Regex(string.Format("{0}(.*?){1}", strBeginTemp, strEndTemp));
            return regex.Replace(s, string.Empty);
        } 


        public void SoftwareControlsLock()
        {
            buttonCreateVerificationFile.Enabled = false;
            buttonVerifySelectedDirectory.Enabled = false;
            textBoxDirectory.Enabled = false;
            checkBoxUseMD5.Enabled = false;
            checkBoxUseSha1.Enabled = false;
            buttonChangeDirectory.Enabled = false;
            checkBoxCreateRecursively.Enabled = false;

            textBoxFilenameToTest.Enabled = false;
            buttonFilenameToTest.Enabled = false;
            checkBoxTestWithMD5.Enabled = false;
            checkBoxTestWithSha1.Enabled = false;
        }

        public void SoftwareControlsUnlock()
        {
            buttonCreateVerificationFile.Enabled = true;
            buttonVerifySelectedDirectory.Enabled = true;
            textBoxDirectory.Enabled = true;
            checkBoxUseMD5.Enabled = true;
            checkBoxUseSha1.Enabled = true;
            buttonChangeDirectory.Enabled = true;
            checkBoxCreateRecursively.Enabled = true;

            textBoxFilenameToTest.Enabled = true;
            buttonFilenameToTest.Enabled = true;
            checkBoxTestWithMD5.Enabled = true;
            checkBoxTestWithSha1.Enabled = true;
        }


        private void buttonVerifySelectedDirectory_Click(object sender, EventArgs e)
        {
            string strRenderFile = "";
            string strRenderFolder = textBoxDirectory.Text.Trim();

            textBoxStandardOutput.Text = "";
            textBoxStandardError.Text = "";

            SoftwareControlsLock();

            if (strRenderFolder == "")
            {
                MessageBox.Show("Select Directory", "Select Directory");
                textBoxDirectory.Focus();
                textBoxDirectory.BackColor = System.Drawing.Color.Yellow;
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }
            else
            {
                textBoxDirectory.BackColor = System.Drawing.Color.White;
            }

            if (!(Directory.Exists(strRenderFolder)))
            {
                MessageBox.Show("Directory doesn't exist", "Directory doesn't exist");
                textBoxDirectory.Focus();
                textBoxDirectory.BackColor = System.Drawing.Color.Yellow;
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }

            strRenderFile = strRenderFolder + "\\fciv.xml";
            if (!(File.Exists(strRenderFile)))
            {
                string strErrorMessage = "";
                strErrorMessage = "Hash file: ";
                strErrorMessage += strRenderFile;
                strErrorMessage += " doesn't exist.";

                MessageBox.Show(strErrorMessage, "Hash file doesn't exist.");
                SoftwareControlsUnlock();
                textBoxDirectory.Focus();
                return;
            }

            try
            {
                using (System.Diagnostics.Process cmdprc = new System.Diagnostics.Process())
                {
                    string strCommand = "";
                    string strArguments = "-v PJWHASHMETHOD -exc fciv -xml \"PJWFOLDER\\fciv.xml\"";
                    string strHashMethod = "";

                    string strStandardOutput = "";
                    string strTempString = "";
                    string strStandardError = "";

                    if ((checkBoxUseMD5.Checked == true) && (checkBoxUseSha1.Checked == true))
                    {
                        strHashMethod = "-both";
                    }
                    else if (checkBoxUseMD5.Checked == true)
                    {
                        strHashMethod = "-md5";
                    }
                    else if (checkBoxUseSha1.Checked == true)
                    {
                        strHashMethod = "-sha1";
                    }
                    else
                    {
                        strHashMethod = "-both";
                    }

                    strCommand = "fciv.exe";
                    strArguments = strArguments.Replace("PJWFOLDER", strRenderFolder);
                    strArguments = strArguments.Replace("PJWHASHMETHOD", strHashMethod);


                    cmdprc.StartInfo.UseShellExecute = false;
                    cmdprc.StartInfo.RedirectStandardError = true;
                    cmdprc.StartInfo.RedirectStandardOutput = true;

                    cmdprc.StartInfo.WorkingDirectory = strRenderFolder;

                    cmdprc.StartInfo.CreateNoWindow = true;
                    cmdprc.StartInfo.FileName = strCommand;
                    cmdprc.StartInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
                    cmdprc.StartInfo.Arguments = strArguments;
                    cmdprc.Start();


                    strTempString = cmdprc.StandardError.ReadLine();
                    while (strTempString != null)
                    {
                        strStandardError += strTempString;
                        strStandardError += "\r\n";
                        strTempString = cmdprc.StandardError.ReadLine();
                    }

                    strTempString = cmdprc.StandardOutput.ReadLine();
                    while (strTempString != null)
                    {
                        strStandardOutput += strTempString;
                        strStandardOutput += "\r\n";
                        strTempString = cmdprc.StandardOutput.ReadLine();
                    }
                    cmdprc.WaitForExit();

                    textBoxStandardError.Text = strStandardError;
                    textBoxStandardOutput.Text = strStandardOutput;
                }
            }
            catch (Exception ex)
            {
                string strErrorMessage = "Be sure that FCIV.exe is installed in the same directory that this software is.\n\n";
                strErrorMessage += ex.Message;
                MessageBox.Show(strErrorMessage);
                SoftwareControlsUnlock();
            }

            SoftwareControlsUnlock();
        }

        private void buttonFilenameToTest_Click(object sender, EventArgs e)
        {
            textBoxStandardOutput.Text = "";
            textBoxStandardError.Text = "";

            System.Windows.Forms.DialogResult drFolderBrowserResult;
            openFileDialog1.FileName = textBoxFilenameToTest.Text.Trim();
            drFolderBrowserResult = openFileDialog1.ShowDialog();
            if (drFolderBrowserResult == System.Windows.Forms.DialogResult.OK)
            {
                textBoxFilenameToTest.Text = openFileDialog1.FileName;
            }
            RunQuickTest();
        }

        private void RunQuickTest()
        {
            string strHashResults = "";
            string strTempString = "";

            SoftwareControlsLock();

            try
            {
                if (((checkBoxTestWithSha1.Checked == false) && (checkBoxTestWithMD5.Checked == false)) || (checkBoxTestWithMD5.Checked == true))
                {
                    using (HashAlgorithm hashAlg = HashAlgorithm.Create("MD5"))
                    {
                        using (Stream file =
                            new FileStream(textBoxFilenameToTest.Text.Trim(), FileMode.Open, FileAccess.Read))
                        {
                            byte[] hash = hashAlg.ComputeHash(file);


                            strHashResults += textBoxFilenameToTest.Text.Trim();
                            strHashResults += "\r\n\r\n";

                            strHashResults += "MD5:\r\n";

                            // hex format with hyphens
                            strTempString = BitConverter.ToString(hash);
                            strHashResults += "\thex format with hyphens:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += strTempString;
                            strHashResults += "\r\n";

                            // hex format without hyphens
                            strTempString = strTempString.Replace("-", "");
                            strHashResults += "\thex format without hyphens:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += strTempString;
                            strHashResults += "\r\n";

                            // base64
                            strHashResults += "\tbase64:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += Convert.ToBase64String(hash);
                            strHashResults += "\r\n";
                        }
                    }
                }

                if (((checkBoxTestWithSha1.Checked == false) && (checkBoxTestWithMD5.Checked == false)) || (checkBoxTestWithSha1.Checked == true))
                {
                    using (HashAlgorithm hashAlg = HashAlgorithm.Create("SHA1"))
                    {
                        using (Stream file =
                            new FileStream(textBoxFilenameToTest.Text.Trim(), FileMode.Open, FileAccess.Read))
                        {
                            byte[] hash = hashAlg.ComputeHash(file);
                            strHashResults += "SHA1:\r\n";

                            // hex format with hyphens
                            strTempString = BitConverter.ToString(hash);
                            strHashResults += "\thex format with hyphens:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += strTempString;
                            strHashResults += "\r\n";

                            // hex format without hyphens
                            strTempString = strTempString.Replace("-", "");
                            strHashResults += "\thex format without hyphens:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += strTempString;
                            strHashResults += "\r\n";

                            // base64
                            strHashResults += "\tbase64:\r\n";
                            strHashResults += "\t\t";
                            strHashResults += Convert.ToBase64String(hash);
                            strHashResults += "\r\n";
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                SoftwareControlsUnlock();
                MessageBox.Show(ex.Message);
            }
            textBoxStandardOutput.Text = strHashResults;

            SoftwareControlsUnlock();
        }

    }
}
